/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1201;

import javax.annotation.Nonnull;
import mcinterface1201.BuilderTileEntity;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityBase;
import minecrafttransportsimulator.blocks.tileentities.components.ITileEntityFluidTankProvider;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityFluidLoader;
import minecrafttransportsimulator.entities.instances.EntityFluidTank;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class BuilderTileEntityFluidTank
extends BuilderTileEntity
implements IFluidTank,
IFluidHandler {
    protected static RegistryObject<BlockEntityType<BuilderTileEntityFluidTank>> TE_TYPE2;
    private EntityFluidTank tank;

    public BuilderTileEntityFluidTank(BlockPos pos, BlockState state) {
        super((BlockEntityType)TE_TYPE2.get(), pos, state);
    }

    @Override
    protected void setTileEntity(ATileEntityBase<?> tile) {
        super.setTileEntity(tile);
        this.tank = ((ITileEntityFluidTankProvider)((Object)tile)).getTank();
    }

    @Override
    public void tick() {
        int amountDrained;
        IFluidHandler fluidHandler;
        BlockEntity teBelow;
        int currentFluidAmount;
        super.tick();
        if (this.tank != null && this.tileEntity instanceof TileEntityFluidLoader && ((TileEntityFluidLoader)this.tileEntity).isUnloader() && (currentFluidAmount = this.getFluidAmount()) > 0 && (teBelow = this.f_58857_.m_7702_(this.m_58899_().m_7495_())) != null && (fluidHandler = (IFluidHandler)teBelow.getCapability(ForgeCapabilities.FLUID_HANDLER, Direction.UP).orElse(null)) != null && (amountDrained = fluidHandler.fill(this.getFluid(), IFluidHandler.FluidAction.EXECUTE)) > 0 && currentFluidAmount == this.getFluidAmount()) {
            this.drain(amountDrained, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public FluidStack getFluid() {
        if (this.tank != null && !this.tank.getFluid().isEmpty()) {
            for (ResourceLocation fluidKey : ForgeRegistries.FLUIDS.getKeys()) {
                if (!fluidKey.m_135815_().equals(this.tank.getFluid())) continue;
                return new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(fluidKey), (int)this.tank.getFluidLevel());
            }
        }
        return FluidStack.EMPTY;
    }

    public int getFluidAmount() {
        return (int)(this.tank != null ? this.tank.getFluidLevel() : 0.0);
    }

    public int getCapacity() {
        return this.tank != null ? this.tank.getMaxLevel() : 0;
    }

    public boolean isFluidValid(FluidStack fluid) {
        return true;
    }

    public int getTanks() {
        return 1;
    }

    public FluidStack getFluidInTank(int tank) {
        return this.getFluid();
    }

    public int getTankCapacity(int tank) {
        return this.getCapacity();
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return this.isFluidValid(stack);
    }

    public int fill(FluidStack stack, IFluidHandler.FluidAction doFill) {
        if (this.tank != null) {
            ResourceLocation fluidLocation = ForgeRegistries.FLUIDS.getKey((Object)stack.getFluid());
            return (int)this.tank.fill(fluidLocation.m_135815_(), fluidLocation.m_135827_(), stack.getAmount(), doFill == IFluidHandler.FluidAction.EXECUTE);
        }
        return 0;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
        if (this.getFluidAmount() > 0) {
            return this.drain(new FluidStack(this.getFluid().getFluid(), maxDrain), doDrain);
        }
        return FluidStack.EMPTY;
    }

    public FluidStack drain(FluidStack stack, IFluidHandler.FluidAction doDrain) {
        ResourceLocation fluidLocation = ForgeRegistries.FLUIDS.getKey((Object)stack.getFluid());
        return new FluidStack(stack.getFluid(), (int)(this.tank != null ? this.tank.drain(fluidLocation.m_135815_(), fluidLocation.m_135827_(), stack.getAmount(), doDrain == IFluidHandler.FluidAction.EXECUTE) : 0.0));
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == ForgeCapabilities.FLUID_HANDLER && facing == Direction.DOWN) {
            return LazyOptional.of(() -> this);
        }
        return super.getCapability(capability, facing);
    }
}

